'From Squeak3.7beta of ''1 April 2004'' [latest update: #5954] on 5 June 2005 at 11:11:41 pm'!
Object subclass: #MacVMCorrectFileTypes
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMConstruction-Building'!
!MacVMCorrectFileTypes commentStamp: '<historical>' prior: 0!
Correct hfs meta data on c or h or precompiled header files, after SVN removes that data. 
This enables earlier versions of CodeWarrior to recognise the files. 

entries _ MacVMCorrectFileTypes new path: 'Macintosh HD:Users:johnmci:Documents:Squeak3.8.0:os9:platforms'.!
]style[(162 107)cred;,f2!


!MacVMCorrectFileTypes methodsFor: 'running' stamp: 'JMM 5/23/2005 17:31'!
checkDirectoryAndCorrect: aDirectory
	| dirs files type |

	aDirectory localName = '.svn' ifTrue: [^self].
	dirs _ aDirectory directoryNames.
	dirs do: [:d | self checkDirectoryAndCorrect: (aDirectory directoryNamed: d)].
	files _ aDirectory fileNames.
	files do: [:f | 
			type _ aDirectory getMacFileTypeAndCreator: f.
			(type at: 1) asLowercase = 'text' ifFalse: [self checkFileName: f inDirectory: aDirectory]]

! !

!MacVMCorrectFileTypes methodsFor: 'running' stamp: 'JMM 5/23/2005 17:37'!
checkFileName: aFileNameString inDirectory: aDirectory
	| tokens suffix |
	tokens _ aFileNameString findTokens: $.. 
	tokens size < 2 ifTrue: [^self].
	suffix _ tokens last. 
	((suffix = 'c') | (suffix = 'h') | (suffix = 'pch')) ifTrue: [
		aDirectory setMacFileNamed: aFileNameString type: 'TEXT' creator: 'R*ch'.
		Transcript show: aDirectory printString,' ',aFileNameString;cr].

! !

!MacVMCorrectFileTypes methodsFor: 'running' stamp: 'JMM 5/23/2005 16:55'!
path: aPath
	| dirs directory |
	directory _ FileDirectory on: aPath.
	dirs _ directory directoryNames.
	dirs do: [:d | self checkDirectoryAndCorrect: (directory directoryNamed: d)].
! !
